<?php
// Admin authentication middleware
session_start();

function requireAdminAuth() {
    // Check if admin is logged in
    if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
        header('Location: login.php');
        exit();
    }
    
    // Check session timeout (4 hours)
    if (isset($_SESSION['admin_login_time']) && (time() - $_SESSION['admin_login_time']) > 14400) {
        session_destroy();
        header('Location: login.php?timeout=1');
        exit();
    }
    
    // Update last activity time
    $_SESSION['admin_last_activity'] = time();
}

function getAdminInfo() {
    return [
        'id' => $_SESSION['admin_id'] ?? null,
        'email' => $_SESSION['admin_email'] ?? null,
        'name' => $_SESSION['admin_name'] ?? null,
        'login_time' => $_SESSION['admin_login_time'] ?? null
    ];
}

function isAdminLoggedIn() {
    return isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true;
}
?>
