<?php
$page_title = "Special Deals";
$page_description = "Discover amazing deals and discounts on premium electronics and household appliances at SavingVest Mart. Limited time offers and special promotions.";

require_once 'config/database.php';
include 'includes/header.php';

$conn = getDBConnection();
$deals = [];
$result = $conn->query("SELECT * FROM products WHERE sale_price IS NOT NULL AND is_active = 1 ORDER BY (price - sale_price) DESC LIMIT 12");
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $deals[] = $row;
    }
}
$conn->close();
?>

<section class="bg-gradient-to-r from-red-500 to-orange-500 py-12 text-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h1 class="text-4xl font-bold mb-4">Special Deals & Offers</h1>
        <p class="text-xl">Limited time offers on premium electronics and appliances</p>
    </div>
</section>

<section class="py-16">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <?php if (empty($deals)): ?>
            <div class="text-center py-12">
                <h2 class="text-2xl font-bold text-gray-900 mb-4">No Active Deals</h2>
                <p class="text-gray-600 mb-8">Check back soon for amazing deals and discounts!</p>
                <a href="products.php" class="bg-primary-500 text-white px-6 py-3 rounded-lg hover:bg-primary-600 font-medium">
                    Browse All Products
                </a>
            </div>
        <?php else: ?>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <?php foreach ($deals as $product): ?>
                    <?php $discount = round((($product['price'] - $product['sale_price']) / $product['price']) * 100); ?>
                    <div class="bg-white rounded-2xl shadow-sm hover:shadow-lg transition-shadow overflow-hidden relative">
                        <div class="absolute top-4 left-4 bg-red-500 text-white px-3 py-1 rounded-full text-sm font-bold z-10">
                            <?php echo $discount; ?>% OFF
                        </div>
                        <div class="aspect-w-16 aspect-h-12 bg-gray-100">
                            <img src="<?php echo htmlspecialchars($product['image_url']); ?>" 
                                 alt="<?php echo htmlspecialchars($product['name']); ?>"
                                 class="w-full h-48 object-cover">
                        </div>
                        <div class="p-6">
                            <h3 class="text-lg font-semibold text-gray-900 mb-2">
                                <?php echo htmlspecialchars($product['name']); ?>
                            </h3>
                            <p class="text-gray-600 text-sm mb-4">
                                <?php echo htmlspecialchars($product['short_description']); ?>
                            </p>
                            
                            <div class="space-y-3">
                                <div class="flex items-center space-x-2">
                                    <span class="text-2xl font-bold text-red-600">₦<?php echo number_format($product['sale_price'], 0); ?></span>
                                    <span class="text-lg text-gray-500 line-through">₦<?php echo number_format($product['price'], 0); ?></span>
                                </div>
                                <div class="text-sm text-green-600 font-medium">
                                    You save ₦<?php echo number_format($product['price'] - $product['sale_price'], 0); ?>
                                </div>
                                <a href="product.php?id=<?php echo $product['id']; ?>" 
                                   class="block w-full bg-primary-500 text-white px-4 py-2 rounded-lg hover:bg-primary-600 transition-colors font-medium text-center">
                                    View Deal
                                </a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</section>

<?php include 'includes/footer.php'; ?>
