<?php
$page_title = "Warranty Information";
$page_description = "Learn about warranty coverage for electronics and appliances at SavingVest Mart, including manufacturer warranties and extended protection plans.";

include 'includes/header.php';
?>

<section class="bg-gray-100 py-8">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <h1 class="text-3xl font-bold text-gray-900">Warranty Information</h1>
        <p class="text-gray-600 mt-2">Comprehensive warranty coverage for your peace of mind</p>
    </div>
</section>

<section class="py-16">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="space-y-12">
            <!-- Manufacturer Warranty -->
            <div>
                <h2 class="text-2xl font-bold text-gray-900 mb-6">Manufacturer Warranty</h2>
                <div class="bg-white rounded-lg shadow-sm p-6">
                    <p class="text-gray-600 mb-6">
                        All products sold at SavingVest Mart come with full manufacturer warranty. 
                        Warranty periods and coverage vary by brand and product category.
                    </p>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <h3 class="text-lg font-semibold text-gray-900 mb-3">Smartphones & Tablets</h3>
                            <ul class="space-y-2 text-gray-600">
                                <li>• Apple: 1 year limited warranty</li>
                                <li>• Samsung: 1 year warranty</li>
                                <li>• Google: 1 year limited warranty</li>
                                <li>• Other brands: 6-12 months</li>
                            </ul>
                        </div>
                        <div>
                            <h3 class="text-lg font-semibold text-gray-900 mb-3">Home Appliances</h3>
                            <ul class="space-y-2 text-gray-600">
                                <li>• Major appliances: 1-2 years</li>
                                <li>• Small appliances: 1 year</li>
                                <li>• Kitchen appliances: 1-3 years</li>
                                <li>• Vacuum cleaners: 2 years</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <!-- What's Covered -->
            <div>
                <h2 class="text-2xl font-bold text-gray-900 mb-6">What's Covered</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="bg-white rounded-lg shadow-sm p-6">
                        <h3 class="text-lg font-semibold text-green-600 mb-3">✓ Covered</h3>
                        <ul class="space-y-2 text-gray-600">
                            <li>• Manufacturing defects</li>
                            <li>• Component failures</li>
                            <li>• Software issues (for electronics)</li>
                            <li>• Normal wear and tear (limited)</li>
                            <li>• Parts and labor</li>
                        </ul>
                    </div>
                    <div class="bg-white rounded-lg shadow-sm p-6">
                        <h3 class="text-lg font-semibold text-red-600 mb-3">✗ Not Covered</h3>
                        <ul class="space-y-2 text-gray-600">
                            <li>• Physical damage from drops</li>
                            <li>• Water damage</li>
                            <li>• Misuse or abuse</li>
                            <li>• Unauthorized repairs</li>
                            <li>• Cosmetic damage</li>
                        </ul>
                    </div>
                </div>
            </div>

            <!-- Extended Warranty -->
            <div>
                <h2 class="text-2xl font-bold text-gray-900 mb-6">Extended Warranty Plans</h2>
                <div class="bg-white rounded-lg shadow-sm p-6">
                    <p class="text-gray-600 mb-6">
                        Protect your investment with our extended warranty plans. Available for most electronics and appliances.
                    </p>
                    
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        <div class="border border-gray-200 rounded-lg p-4">
                            <h3 class="text-lg font-semibold text-gray-900 mb-2">Basic Plan</h3>
                            <p class="text-2xl font-bold text-primary-600 mb-2">₦15,000</p>
                            <ul class="space-y-1 text-sm text-gray-600">
                                <li>• +1 year coverage</li>
                                <li>• Parts & labor</li>
                                <li>• Phone support</li>
                            </ul>
                        </div>
                        <div class="border border-primary-500 rounded-lg p-4 bg-primary-50">
                            <h3 class="text-lg font-semibold text-gray-900 mb-2">Premium Plan</h3>
                            <p class="text-2xl font-bold text-primary-600 mb-2">₦25,000</p>
                            <ul class="space-y-1 text-sm text-gray-600">
                                <li>• +2 years coverage</li>
                                <li>• Accidental damage</li>
                                <li>• Priority support</li>
                                <li>• Home service</li>
                            </ul>
                        </div>
                        <div class="border border-gray-200 rounded-lg p-4">
                            <h3 class="text-lg font-semibold text-gray-900 mb-2">Ultimate Plan</h3>
                            <p class="text-2xl font-bold text-primary-600 mb-2">₦40,000</p>
                            <ul class="space-y-1 text-sm text-gray-600">
                                <li>• +3 years coverage</li>
                                <li>• Complete protection</li>
                                <li>• 24/7 support</li>
                                <li>• Replacement service</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Warranty Claims -->
            <div>
                <h2 class="text-2xl font-bold text-gray-900 mb-6">How to Make a Warranty Claim</h2>
                <div class="bg-white rounded-lg shadow-sm p-6">
                    <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
                        <div class="text-center">
                            <div class="w-12 h-12 bg-primary-100 rounded-full flex items-center justify-center mx-auto mb-3">
                                <span class="text-primary-600 font-bold">1</span>
                            </div>
                            <h3 class="font-semibold text-gray-900 mb-2">Contact Support</h3>
                            <p class="text-sm text-gray-600">Call or email our warranty support team</p>
                        </div>
                        <div class="text-center">
                            <div class="w-12 h-12 bg-primary-100 rounded-full flex items-center justify-center mx-auto mb-3">
                                <span class="text-primary-600 font-bold">2</span>
                            </div>
                            <h3 class="font-semibold text-gray-900 mb-2">Provide Details</h3>
                            <p class="text-sm text-gray-600">Share purchase info and describe the issue</p>
                        </div>
                        <div class="text-center">
                            <div class="w-12 h-12 bg-primary-100 rounded-full flex items-center justify-center mx-auto mb-3">
                                <span class="text-primary-600 font-bold">3</span>
                            </div>
                            <h3 class="font-semibold text-gray-900 mb-2">Get Authorization</h3>
                            <p class="text-sm text-gray-600">Receive warranty claim authorization</p>
                        </div>
                        <div class="text-center">
                            <div class="w-12 h-12 bg-primary-100 rounded-full flex items-center justify-center mx-auto mb-3">
                                <span class="text-primary-600 font-bold">4</span>
                            </div>
                            <h3 class="font-semibold text-gray-900 mb-2">Service/Replace</h3>
                            <p class="text-sm text-gray-600">Get your product repaired or replaced</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Contact for Warranty -->
            <div class="bg-primary-50 rounded-lg p-6 text-center">
                <h2 class="text-2xl font-bold text-gray-900 mb-4">Need Warranty Support?</h2>
                <p class="text-gray-600 mb-6">Our warranty specialists are ready to help with your claim.</p>
                <div class="flex flex-col sm:flex-row gap-4 justify-center">
                    <a href="mailto:warranty@mart.savingvest.com" class="bg-primary-500 text-white px-6 py-3 rounded-lg hover:bg-primary-600 font-medium">
                        Email Warranty Team
                    </a>
                    <a href="tel:+2348087654321" class="border border-primary-500 text-primary-600 px-6 py-3 rounded-lg hover:bg-primary-50 font-medium">
                        Call: +234 808 765 4321
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>
